<?php
    include 'access_token.php';
    // Database connection parameters
    $host = 'localhost';
    $dbname = 'tranzvwy_transfa_payments_2024';
    $username = 'tranzvwy_transfa_payments_2024';
    $password = 'tranzvwy_transfa_payments_2024';
    
    // Create a connection
    $conn = mysqli_connect($host, $username, $password, $dbname);
    
    // Check connection
    if (!$conn) {
        die("Connection failed: " . mysqli_connect_error());
    }

    $OrderTrackingId = $_GET['OrderTrackingId'];
    $OrderMerchantReference = $_GET['OrderMerchantReference'];
    $booking_id = "";
    
    if(APP_ENVIROMENT == 'sandbox'){
      $getTransactionStatusUrl = "https://cybqa.pesapal.com/pesapalv3/api/Transactions/GetTransactionStatus?orderTrackingId=$OrderTrackingId";
    }elseif(APP_ENVIROMENT == 'live'){
      $getTransactionStatusUrl = "https://pay.pesapal.com/v3/api/Transactions/GetTransactionStatus?orderTrackingId=$OrderTrackingId";
    }else{
      echo "Invalid APP_ENVIROMENT";
      exit;
    }
    $headers = array(
        "Accept: application/json",
        "Content-Type: application/json",
        "Authorization: Bearer $token"
    );
    $ch = curl_init($getTransactionStatusUrl);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    $data = json_decode($response, true);


    //Log the transaction in a file
    $logFile = "TransactionCallback.txt";
    $log = fopen($logFile, "a");
    fwrite($log, "\n\n".$response);
    fclose($log);
    
    //Save transaction to db for reference
    // Function to handle null values and convert them to empty strings
    function sanitizeValue($value) {
        return $value === null ? "" : $value;
    }
    
    $fetchSQL = "SELECT * FROM payment_attempts WHERE order_tracking_id = '$OrderTrackingId'";
    $result = mysqli_query($conn, $fetchSQL);
    if (!$result) {
        // If the query failed, print an error message and exit
        //echo "Error: " . $fetchSQL . "<br>" . mysqli_error($conn);
        exit();
    }
    
    // Check if a row was returned
    if (mysqli_num_rows($result) == 1) {
        $row = mysqli_fetch_assoc($result);
        $booking_id = $row['booking_id'];
    } else {
        //echo "No payment attempts found for the given order tracking ID.";
    }
    mysqli_free_result($result);

    $payment_method = sanitizeValue($data['payment_method']);
    $amount = sanitizeValue($data['amount']);
    $created_date = sanitizeValue($data['created_date']);
    $confirmation_code = sanitizeValue($data['confirmation_code']);
    $order_tracking_id = sanitizeValue($data['order_tracking_id']);
    $payment_status_description = sanitizeValue($data['payment_status_description']);
    $description = sanitizeValue($data['description']);
    $message = sanitizeValue($data['message']);
    $payment_account = sanitizeValue($data['payment_account']);
    $call_back_url = sanitizeValue($data['call_back_url']);
    $status_code = sanitizeValue($data['status_code']);
    $merchant_reference = sanitizeValue($data['merchant_reference']);
    $account_number = sanitizeValue($data['account_number']);
    $payment_status_code = sanitizeValue($data['payment_status_code']);
    $currency = sanitizeValue($data['currency']);
    $error_type = sanitizeValue($data['error']['error_type']);
    $error_code = sanitizeValue($data['error']['code']);
    $error_message = sanitizeValue($data['error']['message']);
    $status = sanitizeValue($data['status']);
    
    // Prepare the SQL query
    $sql = "INSERT INTO payment_transactions (
        payment_method, amount, created_date, confirmation_code, order_tracking_id, 
        payment_status_description, description, message, payment_account, 
        call_back_url, status_code, merchant_reference, account_number, 
        payment_status_code, currency, error_type, error_code, error_message, status
    ) VALUES (
        '$payment_method', '$amount', '$created_date', '$confirmation_code', '$order_tracking_id',
        '$payment_status_description', '$description', '$message', '$payment_account',
        '$call_back_url', '$status_code', '$merchant_reference', '$account_number',
        '$payment_status_code', '$currency', '$error_type', '$error_code', '$error_message', '$status'
    )";
    
    if (mysqli_query($conn, $sql))
    {
        //echo "Record saved successfully.";
    }
    else
    {
        //echo "Error: " . $sql . "<br>" . mysqli_error($conn);
    }
    
    // //Send simple json to Backend
    $url = 'https://api.transfa.org/api/booking/update-payment/booking/';
    $data = [
        'payment_method' => $payment_method,
        'amount' => $amount,
        'created_date' => $created_date,
        'confirmation_code' => $confirmation_code,
        'order_tracking_id' => $order_tracking_id,
        'payment_status_description' => $payment_status_description,
        'message' => $message,
        'payment_account' => $payment_account,
        'booking_id' => $booking_id,
    ];
    // Convert to JSON
    $jsonData = json_encode($data);
    // Initialize cURL
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return response as a string
    curl_setopt($ch, CURLOPT_POST, true);           // Set method to POST
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData); // Set the JSON data to send
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',           // Set the content type to JSON
        'Content-Length: ' . strlen($jsonData)     // Set the content length
    ]);
    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'Curl error: ' . curl_error($ch);
    } else {
        echo 'Response: ' . $response;
        echo $data;
    }
    curl_close($ch);
    
    // Close the connection
    mysqli_close($conn);
?>